import { ContactForm } from "@/components/contact/contact-form";
import { CONTACT_INFO, APP_NAME } from "@/constants";
import { Mail, Phone, MapPin } from "lucide-react";
import type { Metadata } from 'next';

export const metadata: Metadata = {
  title: 'Contact Us',
  description: `Get in touch with ${APP_NAME}. Find our office locations, phone numbers, email addresses, or use our contact form.`,
};

export default function ContactPage() {
  return (
    <div className="bg-background text-foreground">
      {/* Hero Section */}
      <section className="py-20 md:py-28 bg-primary/5">
        <div className="container mx-auto px-4 text-center">
          <h1 className="text-4xl md:text-5xl font-bold text-primary mb-4 text-shadow-primary">Contact Us</h1>
          <p className="text-lg md:text-xl text-muted-foreground max-w-3xl mx-auto">
            We're here to help and answer any questions you might have. We look forward to hearing from you!
          </p>
        </div>
      </section>

      {/* Contact Methods Section */}
      <section className="py-16 lg:py-24">
        <div className="container mx-auto px-4">
          <div className="grid md:grid-cols-2 gap-12 lg:gap-16 items-start">
            {/* Contact Form */}
            <div className="order-2 md:order-1">
              <ContactForm />
            </div>

            {/* Contact Details */}
            <div className="order-1 md:order-2 space-y-10">
              <div>
                <h2 className="text-2xl font-semibold text-foreground mb-6">Get in Touch Directly</h2>
                <div className="space-y-4">
                  <div className="flex items-start">
                    <Mail className="h-6 w-6 text-primary mr-3 mt-1 flex-shrink-0" />
                    <div>
                      <h3 className="font-semibold text-foreground">Email Us</h3>
                      <a href={`mailto:${CONTACT_INFO.mainEmail}`} className="text-primary hover:underline">
                        {CONTACT_INFO.mainEmail}
                      </a>
                      {CONTACT_INFO.offices.find(o => o.location.includes("Uganda"))?.email && (
                         <a href={`mailto:${CONTACT_INFO.offices.find(o => o.location.includes("Uganda"))?.email}`} className="block text-primary hover:underline text-sm">
                           {CONTACT_INFO.offices.find(o => o.location.includes("Uganda"))?.email} (Uganda)
                         </a>
                      )}
                    </div>
                  </div>
                  <div className="flex items-start">
                    <Phone className="h-6 w-6 text-primary mr-3 mt-1 flex-shrink-0" />
                    <div>
                      <h3 className="font-semibold text-foreground">Call Us</h3>
                      <a href={`tel:${CONTACT_INFO.mainPhone.replace(/\s/g, "")}`} className="text-primary hover:underline">
                        {CONTACT_INFO.mainPhone} (Kenya)
                      </a>
                      {CONTACT_INFO.offices.find(o => o.location.includes("Uganda"))?.phone && (
                         <a href={`tel:${CONTACT_INFO.offices.find(o => o.location.includes("Uganda"))?.phone?.replace(/\s/g, "")}`} className="block text-primary hover:underline text-sm">
                           {CONTACT_INFO.offices.find(o => o.location.includes("Uganda"))?.phone} (Uganda)
                         </a>
                      )}
                    </div>
                  </div>
                </div>
              </div>

              <div>
                <h2 className="text-2xl font-semibold text-foreground mb-6">Our Offices</h2>
                <div className="space-y-6">
                  {CONTACT_INFO.offices.map((office) => (
                    <div key={office.location} className="flex items-start">
                      <MapPin className="h-6 w-6 text-primary mr-3 mt-1 flex-shrink-0" />
                      <div>
                        <h3 className="font-semibold text-foreground">{office.location}</h3>
                        <address className="not-italic text-muted-foreground text-sm">
                          {office.addressLines.map(line => <p key={line}>{line}</p>)}
                          {office.poBox && <p>{office.poBox}</p>}
                        </address>
                      </div>
                    </div>
                  ))}
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Map Section (Placeholder) - For real map, use @vis.gl/react-google-maps or similar */}
      <section className="py-16 lg:py-24 bg-muted/30">
        <div className="container mx-auto px-4">
          <div className="text-center">
            <h2 className="text-3xl font-bold text-foreground mb-6">Find Us</h2>
            <p className="text-lg text-muted-foreground mb-8 max-w-xl mx-auto">
              Our head office is conveniently located in Nairobi, with a regional office in Kampala.
            </p>
             <div className="aspect-video bg-gray-300 rounded-lg shadow-lg flex items-center justify-center">
                <p className="text-gray-500">Map Placeholder (e.g., Google Maps integration)</p>
             </div>
          </div>
        </div>
      </section>
    </div>
  );
}
