
"use client";

import { useEffect } from 'react';
import { useRouter } from 'next/navigation';
import { useAuthContext } from '@/hooks/use-auth-context';
import { Spinner } from '@/components/ui/spinner';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { LayoutDashboard } from 'lucide-react';
import { APP_NAME } from '@/constants';
// Metadata is now handled by the layout.tsx

export default function DashboardPage() {
  const { user, loading } = useAuthContext();
  const router = useRouter();

  useEffect(() => {
    if (!loading && !user) {
      router.replace('/staff-portal/login');
    }
  }, [user, loading, router]);
  
  // Document title can still be set dynamically if desired, or rely on layout
  useEffect(() => {
    if (typeof window !== 'undefined' && user) { // Ensure user is loaded before setting title with their name
        document.title = `Dashboard | ${APP_NAME} Staff Portal`;
    }
  }, [user]);


  if (loading || !user) {
    return (
      <div className="flex items-center justify-center h-full w-full"> {/* Ensure spinner is centered in the content area */}
        <Spinner size="large" />
      </div>
    );
  }

  return (
    <div className="w-full"> {/* Wrapper for dashboard content */}
      <Card className="shadow-lg w-full">
        <CardHeader className="text-center">
          <LayoutDashboard className="h-10 w-10 text-primary mx-auto mb-3" />
          <CardTitle className="text-2xl font-bold text-primary text-shadow-primary">Staff Dashboard</CardTitle>
          <CardDescription>Welcome, {user.displayName || user.email}!</CardDescription>
        </CardHeader>
        <CardContent className="text-center space-y-6">
          <p className="text-muted-foreground">
            This is your {APP_NAME} staff dashboard.
          </p>
          <p className="text-sm text-muted-foreground">
            Select an option from the sidebar to manage Projects, Services, or News & Insights.
          </p>
          {/* LogoutButton is now in the sidebar footer of the layout */}
        </CardContent>
      </Card>
    </div>
  );
}
