
import type { Metadata } from 'next';
import { APP_NAME } from '@/constants';
import { getSiteSettings } from '@/lib/actions';
import { SettingsForm } from '@/components/staff-portal/settings/settings-form';
import { Card, CardHeader, CardTitle, CardDescription, CardContent } from '@/components/ui/card'; // Added CardContent
import { Separator } from '@/components/ui/separator';

export const metadata: Metadata = {
  title: `Site Settings | ${APP_NAME} Staff Portal`,
  description: `Manage site-wide settings such as logo and favicon for ${APP_NAME}.`,
  robots: {
    index: false,
    follow: false,
  },
};

export const dynamic = 'force-dynamic';

export default async function SiteSettingsPage() {
  const initialSettings = await getSiteSettings();

  return (
    <div className="w-full space-y-8">
      <div>
        <h1 className="text-3xl font-bold text-foreground">Site Settings</h1>
        <p className="text-muted-foreground">
          Manage global settings for your website, like the site logo and favicon.
        </p>
      </div>
      <Separator />
      <Card className="shadow-lg">
        <CardHeader>
          <CardTitle>Branding Assets</CardTitle>
          <CardDescription>
            Upload and manage your site's logo and favicon. These images are stored on Tari.
          </CardDescription>
        </CardHeader>
        <SettingsForm initialSettings={initialSettings} />
      </Card>
       <Card className="shadow-md mt-8">
        <CardHeader>
            <CardTitle className="text-xl">Important Notes</CardTitle>
        </CardHeader>
        <CardContent className="text-sm text-muted-foreground space-y-2">
            <p>
                <strong>Applying Changes:</strong> Changes to the logo and favicon saved here will be stored.
                However, for these changes to reflect across the entire public website and dashboard,
                the respective layout and components (Navbar, Footer, RootLayout for favicon) need to be updated
                to fetch and use these dynamic URLs. Currently, the site uses a statically defined logo.
            </p>
            <p>
                <strong>Favicon Best Practices:</strong> For optimal display across all browsers and devices,
                consider using a `.ico` file for your primary favicon and providing various sizes of `.png` files
                (e.g., 16x16, 32x32, apple-touch-icon.png). This form handles a single favicon upload.
            </p>
             <p>
                <strong>Caching:</strong> Browser and server caching might delay the appearance of updated logos or favicons.
                Hard refreshing (Ctrl+Shift+R or Cmd+Shift+R) or clearing cache might be necessary to see changes immediately.
            </p>
        </CardContent>
      </Card>
    </div>
  );
}
