
"use client";

import { useEffect } from 'react';
import { useRouter } from 'next/navigation';
import { useAuthContext } from '@/hooks/use-auth-context';
import { Spinner } from '@/components/ui/spinner';
import type { Metadata } from 'next'; // For static metadata definition for this wrapper/redirector page
import { APP_NAME } from '@/constants';


// Static metadata for the redirector page itself. Actual content pages (login, dashboard) will have their own.
// export const metadata: Metadata = { // This cannot be exported from client component
//   title: `Staff Portal | ${APP_NAME}`,
//   robots: {
//     index: false,
//     follow: false,
//   },
// };


export default function StaffPortalPage() {
  const { user, loading } = useAuthContext();
  const router = useRouter();

  useEffect(() => {
    if (!loading) {
      if (user) {
        router.replace('/staff-portal/dashboard');
      } else {
        router.replace('/staff-portal/login');
      }
    }
  }, [user, loading, router]);

  if (loading) {
    return (
      <div className="container mx-auto px-4 py-16 min-h-[calc(100vh-10rem)] flex items-center justify-center">
        <Spinner size="large" />
      </div>
    );
  }
  
  // This content will ideally not be seen as redirection should happen quickly
  return (
     <div className="container mx-auto px-4 py-16 min-h-[calc(100vh-10rem)] flex items-center justify-center">
        <p>Redirecting...</p>
      </div>
  );
}

// To set metadata for this page, you'd typically do it in a parent server component or a specific layout for /staff-portal
// For now, I'm removing the direct export of metadata due to "use client"
// You can create `src/app/staff-portal/layout.tsx` and define metadata there.
// Example for layout.tsx:
// export const metadata: Metadata = {
//   title: `Staff Portal | ${APP_NAME}`,
//   robots: { index: false, follow: false },
// };
// export default function StaffPortalLayout({ children }: { children: React.ReactNode }) {
//   return <>{children}</>;
// }
