
"use client"; // Make footer a client component to use context

import Link from "next/link";
import Image from "next/image"; 
import { APP_NAME, SOCIAL_LINKS, CONTACT_INFO, LOGO_URL as FALLBACK_LOGO_URL } from "@/constants";
import { Separator } from "@/components/ui/separator";
import { useSiteSettingsContext } from "@/context/site-settings-provider"; // Import context hook

export function Footer() {
  const currentYear = new Date().getFullYear();
  const siteSettings = useSiteSettingsContext();
  const currentLogoUrl = siteSettings?.logoUrl || FALLBACK_LOGO_URL;

  return (
    <footer className="bg-muted/50 text-muted-foreground border-t">
      <div className="container py-12 px-4 sm:px-6 lg:px-8">
        <div className="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-8">
          {/* Brand and Mission */}
          <div className="md:col-span-3 lg:col-span-1">
            <Link href="/" className="flex items-center gap-2 mb-4">
              <Image src={currentLogoUrl} alt={APP_NAME + " Logo"} width={40} height={40} className="object-contain" />
              <span className="text-2xl font-bold text-primary text-shadow-primary">{APP_NAME}</span>
            </Link>
            <p className="text-sm">
              Empowering communities through financial literacy, agribusiness training, and innovative digital solutions across East Africa.
            </p>
          </div>

          {/* Quick Links */}
          <div>
            <h3 className="text-sm font-semibold text-foreground tracking-wider uppercase mb-4">Quick Links</h3>
            <ul className="space-y-2">
              <li><Link href="/about" className="text-sm hover:text-primary transition-colors">About Us</Link></li>
              <li><Link href="/services" className="text-sm hover:text-primary transition-colors">Services</Link></li>
              <li><Link href="/projects" className="text-sm hover:text-primary transition-colors">Projects</Link></li>
              <li><Link href="/contact" className="text-sm hover:text-primary transition-colors">Contact Us</Link></li>
              <li><Link href="/staff-portal" className="text-sm hover:text-primary transition-colors">Staff Login</Link></li>
            </ul>
          </div>

          {/* Contact Info */}
          <div>
            <h3 className="text-sm font-semibold text-foreground tracking-wider uppercase mb-4">Contact</h3>
            <address className="space-y-2 not-italic text-sm">
              <p>{CONTACT_INFO.offices[0].addressLines.join(", ")}</p>
              <p>{CONTACT_INFO.offices[0].poBox}</p>
              <a href={`mailto:${CONTACT_INFO.mainEmail}`} className="block hover:text-primary transition-colors">{CONTACT_INFO.mainEmail}</a>
              <a href={`tel:${CONTACT_INFO.mainPhone.replace(/\s/g, "")}`} className="block hover:text-primary transition-colors">{CONTACT_INFO.mainPhone}</a>
            </address>
          </div>
          
          {/* Social Media */}
          <div>
            <h3 className="text-sm font-semibold text-foreground tracking-wider uppercase mb-4">Follow Us</h3>
            <div className="flex space-x-4">
              {SOCIAL_LINKS.map((social) => (
                <a
                  key={social.name}
                  href={social.href}
                  target="_blank"
                  rel="noopener noreferrer"
                  className="text-muted-foreground hover:text-primary transition-colors"
                  aria-label={social.name}
                >
                  <social.icon className="h-6 w-6" />
                </a>
              ))}
            </div>
          </div>
        </div>

        <Separator className="my-8 bg-border" />

        <div className="text-center text-sm">
          <p>&copy; {currentYear} {APP_NAME}. All rights reserved.</p>
          <p className="mt-1">
            Website by{" "}
            <a href="https://firebase.google.com/docs/hosting" target="_blank" rel="noopener noreferrer" className="hover:text-primary underline">
              Firebase Studio
            </a>
          </p>
        </div>
      </div>
    </footer>
  );
}
