
import Image from "next/image";
import type { Project } from "@/types";
import { Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Button } from "@/components/ui/button";
import { ChevronRight } from "lucide-react";
import Link from "next/link";

interface ProjectCardProps {
  project: Project;
}

export function ProjectCard({ project }: ProjectCardProps) {
  return (
    <Card className="flex flex-col h-full overflow-hidden shadow-lg hover:shadow-xl transition-shadow duration-300">
      <div className="relative w-full h-48">
        <Image
          src={project.imageUrl}
          alt={project.title}
          fill
          style={{objectFit: 'cover'}}
          data-ai-hint={project.imageHint}
        />
      </div>
      <CardHeader>
        <CardTitle className="text-xl font-semibold text-primary text-shadow-primary">{project.title}</CardTitle>
        <CardDescription>
          In collaboration with <span className="font-medium text-foreground">{project.organization}</span>
        </CardDescription>
      </CardHeader>
      <CardContent className="flex-grow">
        <p className="text-sm text-muted-foreground mb-3 line-clamp-3">{project.description}</p>
        <div className="space-y-1">
          <h4 className="text-xs font-semibold uppercase text-foreground/80">Key Impacts:</h4>
          {project.impact.slice(0, 2).map((item, index) => (
             <p key={index} className="text-xs text-muted-foreground">&bull; {item}</p>
          ))}
          {project.impact.length > 2 && <p className="text-xs text-muted-foreground">&bull; and more...</p>}
        </div>
      </CardContent>
      <CardFooter>
        <Button variant="outline" size="sm" asChild className="text-accent border-accent hover:bg-accent/10">
          <Link href={`/projects/${project.id}`} aria-label={`Learn more about project ${project.title}`}>
            Learn More <ChevronRight className="ml-1 h-4 w-4" />
          </Link>
        </Button>
      </CardFooter>
    </Card>
  );
}
