
import type { Service } from "@/types";
import { Card, CardContent, CardHeader, CardTitle, CardDescription, CardFooter } from "@/components/ui/card";
import { CheckCircle, ChevronRight } from "lucide-react";
import { Button } from "@/components/ui/button";
import Link from "next/link";

interface ServiceCardProps {
  service: Service;
}

export function ServiceCard({ service }: ServiceCardProps) {
  return (
    <Card className="h-full flex flex-col shadow-lg hover:shadow-xl transition-shadow duration-300">
      <CardHeader className="flex flex-row items-start gap-4 pb-4">
        {service.icon && <service.icon className="h-10 w-10 text-primary mt-1 flex-shrink-0" />}
        <div>
          <CardTitle className="text-xl font-semibold text-primary text-shadow-primary">{service.title}</CardTitle>
          <CardDescription className="text-sm mt-1 line-clamp-2">{service.description}</CardDescription>
        </div>
      </CardHeader>
      <CardContent className="flex-grow">
        <ul className="space-y-2">
          {service.details.slice(0, 3).map((detail, index) => ( // Show first 3 details as a teaser
            <li key={index} className="flex items-start text-sm">
              <CheckCircle className="h-5 w-5 text-accent mr-2 mt-0.5 flex-shrink-0" />
              <span className="text-muted-foreground line-clamp-1">{detail}</span>
            </li>
          ))}
          {service.details.length > 3 && (
             <li className="flex items-start text-sm">
                <CheckCircle className="h-5 w-5 text-accent mr-2 mt-0.5 flex-shrink-0 invisible" /> {/* Placeholder for alignment */}
                <span className="text-muted-foreground italic">...and more.</span>
             </li>
          )}
        </ul>
      </CardContent>
      <CardFooter>
        <Button variant="outline" size="sm" asChild className="text-accent border-accent hover:bg-accent/10 w-full">
          <Link href={`/services/${service.id}`} aria-label={`Learn more about ${service.title}`}>
            View Details <ChevronRight className="ml-1 h-4 w-4" />
          </Link>
        </Button>
      </CardFooter>
    </Card>
  );
}
