
"use client";

import { useTransition } from "react";
import { Button } from "@/components/ui/button";
import { useToast } from "@/hooks/use-toast";
import { seedInitialProjects, type SeedProjectsState } from "@/lib/actions";
import { UploadCloud } from "lucide-react"; // Or a more relevant icon

export function SeedProjectsButton() {
  const [isPending, startTransition] = useTransition();
  const { toast } = useToast();

  const handleSeedProjects = async () => {
    startTransition(async () => {
      const result: SeedProjectsState = await seedInitialProjects();
      if (result.success) {
        toast({
          title: "Seeding Complete",
          description: result.message,
        });
      } else {
        toast({
          title: "Seeding Failed",
          description: result.message,
          variant: "destructive",
        });
        if (result.errors) {
          result.errors.forEach(err => console.error("Seeding error detail:", err));
        }
      }
    });
  };

  return (
    <Button onClick={handleSeedProjects} disabled={isPending} variant="outline">
      <UploadCloud className="mr-2 h-4 w-4" />
      {isPending ? "Importing..." : "Import Initial Project Content"}
    </Button>
  );
}
