
import type { LucideIcon } from "lucide-react";

export type NavLink = {
  href: string;
  label: string;
  icon?: LucideIcon | string; // Can be a LucideIcon component or a string (URL for an image)
};

export type Service = {
  id: string;
  title: string;
  description: string;
  details: string[];
  icon?: LucideIcon;
};

export type Project = {
  id: string; // Firestore doc ID
  title: string;
  organization: string;
  description: string;
  imageUrl: string; // This will now be a URL from Tari
  imageHint: string;
  impact: string[];
  createdAt?: string; // Serialized as ISO string for client components
  imagePathTari?: string; // Path for Tari API operations (e.g., deletion)
};

export type OfficeContact = {
  location: string;
  addressLines: string[];
  poBox?: string;
  email?: string;
  phone?: string;
  icon?: LucideIcon;
};

export type SocialLink = {
  name: string;
  href: string;
  icon: LucideIcon;
};

export interface TariFile {
  name: string;
  type: string; 
  size?: number;
  modified?: string; // Date string
  url: string; 
  path: string; 
  public_url?: string; 
  files_count?: number; 
}

export interface SiteSettings {
  logoUrl?: string;
  logoPathTari?: string;
  faviconUrl?: string;
  faviconPathTari?: string;
}
